// Round Robin Scheduling function

function [tat,wait_time]=roundrobin(num,btime,wtime,tatime)
b=0;
t=0;
n=num
q=5;                //quantum time
wtime=zeros(1,n); //waiting time
fd = %io(2);
rtime=btime         // burst time

//For loop : running the processes for specified quantum 

for i=1:1:n         //running the processes for 1 quantum 
    if(rtime(i)>=q)
        for j=1:1:n
            if(j==i)
                rtime(i)=rtime(i)-q;    //setting the remaining time if it is the process scheduled
            else if(rtime(j)>0)
                    wtime(j)=wtime(j)+q;    //incrementing wait time if it is not the process scheduled
                end
            end
        end
    else if(rtime(i)>0)             
            for j=1:1:n
              if(j==i)
                rtime(i)=0;                 //as the remaining time is less than quantum it will run the process and end it
              else if(rtime(j)>0)
                    wtime(j)=wtime(j)+rtime(i);     //incrementing wait time if it is not the process scheduled
                  end 
              end
            end
        end
    end
end
for i=1:1:n
    if(rtime(i)>0)      //if remaining time is left set flag
        flag=1;
    end
end
while(flag==1)          //if flag is set run the above process again
    flag=0;
    for i=1:1:n
        if(rtime(i)>=q)
            for j=1:1:n
                if(j==i)
                    rtime(i)=rtime(i)-q;
                else if(rtime(j)>0)
                        wtime(j)=wtime(j)+q;
                    end
                end
            end
        else if(rtime(i)>0)
                for j=1:1:n
                    if(j==i)
                        rtime(i)=0;
                    else if(rtime(j)>0)
                            wtime(j)=wtime(j)+rtime(i);
                        end 
                    end
                end
            end
        end
    end
    for i=1:1:n
        if(rtime(i)>0)
            flag=1;
        end
    end
end

//For loop : calculating turn around time for each process 
for i=1:1:n
    tatime(i)=wtime(i)+btime(i);    //By adding waiting time and burst time
end
for i=1:1:n
    b=b+wtime(i);
    t=t+tatime(i);
end

for i=1:1:n
    mfprintf(fd,'   P%d is %d',i,tatime(i)); 
end

//displaying the Average Turn-Around Time in RR

mfprintf(fd,'\n  Average Turn-Around Time in RR       %.2f',t/n);

endfunction
